local iIndex = Var("GameCommand"):GetIndex();
local sName = Var("GameCommand"):GetName();
local sGameName = GAMESTATE:GetCurrentGame():GetName();

-- we need to check who joined first.
local masterPlayerNum = GAMESTATE:GetMasterPlayerNumber();

local t = Def.ActorFrame{
	Name="Item"..iIndex;
	--InitCommand=cmd(fov,40);
	InitCommand=cmd(fov,45);

	OffFocusedCommand=cmd(linear,0.2;y,SCREEN_CENTER_Y);
	OffUnfocusedCommand=cmd(runcommandsonleaves,cmd(linear,0.2;diffusealpha,0));

	-- items were SCREEN_WIDTH*0.625, 64
	LoadActor( THEME:GetPathB("","_frame 3x3"), "_rounded blackinset transparent normal", SCREEN_WIDTH*0.625, SCREEN_HEIGHT*0.1)..{
		Name="BGFrame";
		GainFocusCommand=cmd(finishtweening;linear,0.2;diffuse,color("1,1,1,1"));
		LoseFocusCommand=cmd(linear,0.2;diffuse,color("0.5,0.5,0.5,1"););
	};

	AutoText("frutiger")..{
		Name="StyleName"..iIndex;
		Text=sName;
		InitCommand=cmd(x,-100;y,-10;horizalign,left;shadowlength,0;strokecolor,color("0,0,0,0.25"));
		GainFocusCommand=cmd(finishtweening;linear,0.2;diffuse,1,1,1,1;);
		LoseFocusCommand=cmd(linear,0.2;diffuse,0.5,0.5,0.5,1;);
	};
	AutoText("frutiger")..{
		Name="StyleDesc"..iIndex;
		Text=THEME:GetString(Var 'LoadingScreen',sName.."-"..sGameName);
		InitCommand=cmd(x,-100;y,10;horizalign,left;shadowlength,0;zoom,0.8;strokecolor,color("0,0,0,0.25"));
		GainFocusCommand=cmd(finishtweening;linear,0.2;diffuse,1,1,1,1;);
		LoseFocusCommand=cmd(linear,0.2;diffuse,0.5,0.5,0.5,1;);
	};
};

local pad = playername(masterPlayerNum);

local padGainFocusCmd = cmd(finishtweening;glowshift;effectcolor1,1,1,1,0;effectcolor2,1,1,1,0.5);
local padLoseFocusCmd = cmd(stopeffect);

local padRotation = -45; -- was 45 for 3d models

-- check the style here so we can see what to add
-- models were zoom,0.2;
if(sName == "Single" or sName == "Solo") then
	--t[#t+1] = LoadActor( THEME:GetPathG('','_pads/thepad.lua') )..{
	t[#t+1] = LoadActor( THEME:GetPathG('','_common/_pad') )..{
		Name="PadSingle"..pad;
		InitCommand=cmd(x,-SCREEN_WIDTH/3.95;rotationx,padRotation;diffuse,PlayerColor(masterPlayerNum););
		GainFocusCommand=padGainFocusCmd;
		LoseFocusCommand=padLoseFocusCmd;
	};
elseif(sName == "Versus") then
	--t[#t+1] = LoadActor( THEME:GetPathG('','_pads/thepad.lua') )..{
	t[#t+1] = LoadActor( THEME:GetPathG('','_common/_pad') )..{
		Name="PadVersusP1";
		InitCommand=cmd(x,-SCREEN_WIDTH/3.95;rotationx,padRotation;diffuse,PlayerColor(PLAYER_1););
		GainFocusCommand=padGainFocusCmd;
		LoseFocusCommand=padLoseFocusCmd;
	};
	--t[#t+1] = LoadActor( THEME:GetPathG('','_pads/thepad.lua') )..{
	t[#t+1] = LoadActor( THEME:GetPathG('','_common/_pad') )..{
		Name="PadVersusP2";
		InitCommand=cmd(x,SCREEN_WIDTH/3.95;rotationx,padRotation;diffuse,PlayerColor(PLAYER_2););
		GainFocusCommand=padGainFocusCmd;
		LoseFocusCommand=padLoseFocusCmd;
	};
elseif(sName == "Double") then
	--t[#t+1] = LoadActor( THEME:GetPathG('','_pads/thepad.lua') )..{
	t[#t+1] = LoadActor( THEME:GetPathG('','_common/_pad') )..{
		Name="PadDouble1";
		InitCommand=cmd(x,-SCREEN_WIDTH/3.95;rotationx,padRotation;diffuse,PlayerColor(masterPlayerNum););
		GainFocusCommand=padGainFocusCmd;
		LoseFocusCommand=padLoseFocusCmd;
	};
	--t[#t+1] = LoadActor( THEME:GetPathG('','_pads/thepad.lua') )..{
	t[#t+1] = LoadActor( THEME:GetPathG('','_common/_pad') )..{
		Name="PadDouble2";
		InitCommand=cmd(x,SCREEN_WIDTH/3.95;rotationx,padRotation;diffuse,PlayerColor(masterPlayerNum););
		GainFocusCommand=padGainFocusCmd;
		LoseFocusCommand=padLoseFocusCmd;
	};
elseif(sName == "Routine") then -- debugging purposes only
	t[#t+1] = LoadActor( THEME:GetPathG('','_common/_pad') )..{
		Name="PadRoutine1";
		InitCommand=cmd(x,-SCREEN_WIDTH/3.95;rotationx,padRotation;diffuse,PlayerColor(masterPlayerNum););
		GainFocusCommand=padGainFocusCmd;
		LoseFocusCommand=padLoseFocusCmd;
	};
	t[#t+1] = LoadActor( THEME:GetPathG('','_common/_pad') )..{
		Name="PadRoutine2";
		InitCommand=cmd(x,SCREEN_WIDTH/3.95;rotationx,padRotation;diffuse,PlayerColor(masterPlayerNum););
		GainFocusCommand=padGainFocusCmd;
		LoseFocusCommand=padLoseFocusCmd;
	};
end;

return t;